package gov.va.med.mhv.usermgmt.integration.adapter;


import gov.va.med.mhv.integration.phr.transfer.PatientIdentifier;
import gov.va.med.mhv.usermgmt.enumeration.ExtractType;
import gov.va.med.mhv.usermgmt.service.adapter.PhrConfigProperties;
import gov.va.med.mhv.usermgmt.transfer.Patient;

import java.io.IOException;
import java.util.List;
import java.util.Map;

import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.NoHttpResponseException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.MappingJsonFactory;

public class PhrManagerAdapter {
	
	   private static final Log LOG = LogFactory.getLog(PhrManagerAdapter.class);
	
	public static final 	String refreshEndPointType 	= "/refresh";
	public static final 	String statusEndPointType 	= "/status";
	public static final 	String content_type 		= "application/json";
	public static final 	String accept_type 			= "application/json";
	public static final		String auth_key				= "X-Authorization-Key";
	public static final		String content_type_key		= "content-type";
	public static final		String accept_type_key		= "accept";
												  
	
	public void refreshData(Patient patient, 
	        List<String> stationNumbers) throws Exception {
		PhrConfigProperties phrProp = PhrConfigProperties.getInstance();
		long s = System.currentTimeMillis();	
		String endpointUrl = phrProp.getNewphr_env_wsdlurl();
		String endpointUrlFinal = endpointUrl + refreshEndPointType + "/" +patient.getIcn();
		//String endpointUrlFinal = endpointUrl + refreshEndPointType + "/" +icn;
		HttpClient client = new HttpClient();
		client.getHttpConnectionManager().getParams().setConnectionTimeout(phrProp.getConnectTimeout());
		client.getHttpConnectionManager().getParams().setSoTimeout(phrProp.getRequestTimeout());
		PostMethod mPost = new PostMethod( endpointUrlFinal);
		
		if (LOG.isInfoEnabled()) {
			LOG.info("Refresh Data Endpoint : " + endpointUrlFinal);
		}
	
		Header mtHeader21 = new Header();
		mtHeader21.setName(content_type_key);
		mtHeader21.setValue(content_type);
		mPost.addRequestHeader(mtHeader21);

		Header mtHeader22 = new Header();
		mtHeader22.setName(accept_type_key);
		mtHeader22.setValue(accept_type);
		mPost.addRequestHeader(mtHeader22);

		Header mtHeader23 = new Header();
		mtHeader23.setName(auth_key);
		mtHeader23.setValue(phrProp.getNewphr_auth_key());
		mPost.addRequestHeader(mtHeader23);
		String output2 = null;
		try {
			client.executeMethod(mPost);
			output2 = mPost.getResponseBodyAsString( );
//			System.out.println("Refresh Response : " + output2);
			if (LOG.isInfoEnabled()) {
				LOG.info("Refresh Response : " + output2);
				LOG.info("NEW Phr refreshData took " + (System.currentTimeMillis() -s) +" ms for UserProfile: " +patient.getUserProfile().getId());
			}	
			MappingJsonFactory factory = new MappingJsonFactory();
			JsonParser parser = factory.createJsonParser(output2.getBytes());
			Map response = parser.readValueAs(Map.class);
		} catch (NoHttpResponseException e) {
			if (LOG.isErrorEnabled()) {
				LOG.error("Unable to communicate for Refresh Data : ");
			}
		} catch (JsonProcessingException  ex) {
			if (LOG.isErrorEnabled()) {
				LOG.error("Unable to parse Get RefreshData response: " +output2);
			}
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} finally {
			mPost.releaseConnection( );
		}

        
	}
	
	public gov.va.med.mhv.integration.phr.transfer.PatientExtractStatus getExtractStatus(ExtractType extractType, Patient patient) {
		
//		gov.va.med.mhv.integration.phr.transfer.PatientExtractStatus result = new gov.va.med.mhv.integration.phr.transfer.
//							PatientExtractStatus(new PatientIdentifier(patient.getIcn()));
		
		gov.va.med.mhv.integration.phr.transfer.PatientExtractStatus result = null;
		
		PhrConfigProperties phrProp = PhrConfigProperties.getInstance();
		long s = System.currentTimeMillis();
		HttpClient client = new HttpClient();
		client.getHttpConnectionManager().getParams().setConnectionTimeout(phrProp.getConnectTimeout());
		client.getHttpConnectionManager().getParams().setSoTimeout(phrProp.getRequestTimeout());
		
		String endpointUrl = phrProp.getNewphr_env_wsdlurl();
		String endpointUrlFinal = endpointUrl + statusEndPointType + "/" + patient.getIcn();
		
		GetMethod mGet = new GetMethod( endpointUrlFinal);
		//GetMethod mGet = new GetMethod("http://localhost:7001/MockPHRService/mhvapi/v1/phrmgr/status/1234");
		if (LOG.isInfoEnabled()) {
			LOG.info("Get Extract Status Endpoint : " + endpointUrlFinal);
		}
		Header mtHeader21 = new Header();
		mtHeader21.setName(content_type_key);
		mtHeader21.setValue(content_type);
		mGet.addRequestHeader(mtHeader21);

		Header mtHeader22 = new Header();
		mtHeader22.setName(accept_type_key);
		mtHeader22.setValue(accept_type);
		mGet.addRequestHeader(mtHeader22);

		
		Header mtHeader23 = new Header();
		mtHeader23.setName(auth_key);
		mtHeader23.setValue(phrProp.getNewphr_auth_key());
		mGet.addRequestHeader(mtHeader23);
		String output2 = null;
		try {
			client.executeMethod(mGet);
			output2 = mGet.getResponseBodyAsString( );
//			System.out.println("Extract Status Response : " + output2);
			if (LOG.isInfoEnabled()) {
				LOG.info("Extract Status Response : " + output2);
				LOG.info("NEW Phr Get Extract took " + (System.currentTimeMillis() -s) +" ms for UserProfile: " +patient.getUserProfile().getId()); 
			}
			MappingJsonFactory factory = new MappingJsonFactory();
			JsonParser parser = factory.createJsonParser(output2.getBytes());
			//Map response = parser.readValueAs(Map.class);
			result = 
				parser.readValueAs(gov.va.med.mhv.integration.phr.transfer.PatientExtractStatus.class);
			
		} catch (NoHttpResponseException e) {
			if (LOG.isErrorEnabled()) {
				LOG.error("Unable to communicate for Get Extract : ");
			}
		} catch (JsonProcessingException  ex) {
			if (LOG.isErrorEnabled()) {
				LOG.error("Unable to parse extract status response: " +output2);
			}
		}
		catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} finally {
			mGet.releaseConnection( );
		}
		
		return result;
	}
}
